<?php 

require_once '_config.php';

// REDIRECT TO DASHBOARD IF ALREADY LOGGED IN
if(isset($USER_SESSION->backend_user_login) == true ){ 
    REDIRECT("dashboard.php"); 
exit; 
}

CSRF();

// LOGIN POST REQUEST
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
   
    // EMAIL SANITIZATION
    $email = filter_var($_POST['email'], FILTER_SANITIZE_EMAIL);
    $user = $db->query("SELECT * FROM `users` WHERE `email` LIKE '".$email."' AND `password` LIKE '".md5($_POST['password'])."'")->fetchAll();

    if (isset($user[0]['id'])){
        if ($user[0]['status'] == 1 ) {

            $lang = explode('_', $_POST['user_language']);

            // IF USER ACCOUNT STATUS ACTIVE
            $SESSION_ARRAY = array(
                "backend_user_login" => true,
                "backend_user_id" => $user[0]['user_id'],
                "backend_user_email" => $user[0]['email'],
                "backend_user_type" => $user[0]['user_type'],
                "backend_user_status" => $user[0]['status'],
                "backend_user_name" => $user[0]['first_name']. ' ' .$user[0]['last_name'],
                "backend_user_language" => $lang[0],
                "backend_user_language_position" => $lang[1],
            );

            $_SESSION['phptravels_backend_user'] = ENCODE($SESSION_ARRAY);

            // SEND EMAIL
            // $title = "User Login";
            // $template = "login";
            // $content = $_SERVER['REMOTE_ADDR'];
            // $receiver_email = $user[0]['email'];
            // $receiver_name = $user[0]['first_name'];
            // AJAXMAIL($template,$title,$content,$receiver_email,$receiver_name);

            // INSERT TO LOGS
            $user_id = $user[0]['user_id'];    
            $log_type = "login";
            $datetime = date("Y-m-d h:i:sa");
            $desc = "user logged into account";
            logs($user_id,$log_type,$datetime,$desc);

            REDIRECT('dashboard.php');
            
        // REDIRECT TO USER VERIFICATION PAGE
        } else { 

         // INSERT TO LOGS
         $user_id = "";    
         $log_type = "login";
         $datetime = date("Y-m-d h:i:sa");
         $desc = "user tried to loggin but account is not active";
         logs($user_id,$log_type,$datetime,$desc);

         ALERT_MSG('not_active');
         REDIRECT('login.php');

      }

    } else {

    // INSERT TO LOGS
    $user_id = "";    
    $log_type = "login";
    $datetime = date("Y-m-d h:i:sa");
    $desc = "invalid user login credentials";
    logs($user_id,$log_type,$datetime,$desc);
    
    ALERT_MSG('invalid_login');
    REDIRECT("login.php");

    }

}

// GET DATA
$params = array();
$languages = GET('languages',$params);

?>
<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <title>Administrators Login</title>
    <link rel="shortcut icon" href="../uploads/global/favicon.png">
    <link rel="stylesheet" href="./assets/css/style.css" />
    <link rel="stylesheet" href="./assets/css/app.css" />
    <script src="./assets/js/jquery-3.6.0.min.js"></script>
</head>

<body style="background-color: #e1e6ed;">
    <div class="container">
        <div class="row justify-content-center">
            <div class="col-xxl-4 col-xl-5 col-lg-6 col-md-8"
                style="display: flex; align-items: center; height: 100vh;justify-content: center;">
                <div class="card mt-3 mb-4 w-100 p-4">
                    <div class="card-body p-3">
                        <div class="text-center">
                            <img class="mb-3" src="../uploads/global/favicon.png" alt="favicon" style="height: 48px">
                            <p class="mb-0"><strong>Administrators Login</strong></p>
                        </div>
                        <!-- Login submission form-->
                        <form name="form" action="./login.php" method="post" onsubmit="submission()">
                            <div class="mb-2 mt-3">
                                <div class="form-floating">
                                    <input type="email" class="form-control" id="email" name="email"
                                        placeholder="Email">
                                    <label for="">Email</label>
                                </div>
                            </div>
                            <div class="mb-2">
                                <div class="form-floating">
                                    <input type="password" class="form-control" id="password" name="password"
                                        placeholder="Password">
                                    <label for="">Password</label>
                                </div>
                            </div>

                            <select title="Select your language btn btn-primary" class="w-100 selectpicker"
                                name="user_language" data-size="5">
                                <?php foreach($languages as $lang){ 
                                if ($lang->status == 1){ 
                                ?>
                                <option selected value="<?=strtolower($lang->country_id)?>_<?=strtolower($lang->type)?>" data-content="<img class='' src='./assets/img/flags/<?=strtolower($lang->country_id)?>.svg' style='width: 20px; margin-right: 14px;color:#fff'><span style='font-weight: 400; font-size: 14px;' class='text-dark'> <?=$lang->name?></span>">
                                </option>
                                <?php } } ?>
                            </select>
                            <script>
                                $("[name='user_language']").val("us_ltr")
                            </script>
                            <div class="d-flex align-items-center justify-content-between mt-3">
                                <div class="form-check">
                                    <input class="form-check-input" type="checkbox" value="" id="flexCheckChecked"
                                        checked>
                                    <label class="form-check-label" for="flexCheckChecked">
                                        <small>Remember Me</small>
                                    </label>
                                </div>
                                <div class="form-group d-flex align-items-center justify-content-betweenmb-0">
                                    <a class="small fw-500 text-decoration-none" href="login-forget-password.php">Forgot
                                        Password?</a>
                                </div>
                            </div>
                            <button id="submit" class="login_button mt-3 btn btn-primary w-100 btn-lg" type="submit"
                                style="height:50px">Login</button>
                            <div class="d-none">
                                <button class="btn btn-primary w-100 mt-3" type="button" disabled style="height:50px">
                                    <span class="spinner-border spinner-border-sm" role="status"
                                        aria-hidden="true"></span>
                                    Loading...
                                </button>
                            </div>
                            <input type="hidden" name="form_token" value="<?=$_SESSION["form_token"]?>">
                        </form>
                    </div>
                    <hr>
                    <div class="d-flex justify-content-center gap-2">
                    <small>
                    Powered by <a href="https://phptravels.com" target="_blank">
                    <img style="max-width:20px" src='data:image/png;base64,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' alt="">    
                    <strong>PHPTRAVELS</strong></a>
                    </small>
                    </div>

                </div>
            </div>
        </div>
    </div>

    <script src="./assets/js/toast.js"></script>
    <script src="./assets/js/toast-alerts.js"></script>
    <script src="./assets/js/bootstrap.bundle.min.js"></script>
    <script src="./assets/js/bootstrap-select.js"></script>

    <script>
    function submission() {
        document.querySelector('.d-none').classList.remove('d-none');
        document.querySelector('.login_button').classList.add('d-none');

        let email = $("#email").val();
        if (email == "") {
            event.preventDefault();
            alert("Email is required to login");
            window.location.href = "<?=root?>login.php";
        }

        let pass = $("#password").val();
        if (pass == "") {
            event.preventDefault();
            alert("Password is required to login");
            window.location.href = "<?=root?>login.php";
        }
    }

    var hash = window.location.hash.substr(1);
    if (hash == "invalid") {
        vt.error("Email or password incorrect", {
            title: "Invalid Credentials",
            position: "bottom-center",
            callback: function() {}
        })
    }

    if (hash == "password-reset-completed") {
        vt.success("Please check your email for the new password", {
            title: "Password Reset",
            position: "bottom-center",
            callback: function() {}
        })
    }
    </script>

    <style>
    .dropdown-toggle::after {
    right: 10px;
    color: rgb(86 86 86 / 48%);
    position: absolute;
    }
    .card {
    -webkit-box-shadow: 0 2px 6px rgb(0 0 0 / 20%);
    -moz-box-shadow: 0 2px 6px rgba(0,0,0,.2);
    box-shadow: 0 2px 6px rgb(0 0 0 / 20%);
    }
    </style>

</body>

</html>